MODULE SVD
IMPLICIT NONE
INTEGER, PARAMETER  :: dp = SELECTED_REAL_KIND(12, 60)

! Based upon routines from the NSWC (Naval Surface Warfare Center),
! which were based upon LAPACK routines.

! Code converted using TO_F90 by Alan Miller
! Date: 2003-11-11  Time: 17:50:44


CONTAINS


SUBROUTINE drotg(da, db, dc, ds)

!     DESIGNED BY C.L.LAWSON, JPL, 1977 SEPT 08

!     CONSTRUCT THE GIVENS TRANSFORMATION

!           ( DC  DS )
!     G = (          ) ,    DC**2 + DS**2 = 1 ,
!           (-DS  DC )

!     WHICH ZEROS THE SECOND ENTRY OF THE 2-VECTOR  (DA,DB)**T .

!     THE QUANTITY R = (+/-)SQRT(DA**2 + DB**2) OVERWRITES DA IN
!     STORAGE.  THE VALUE OF DB IS OVERWRITTEN BY A VALUE Z WHICH
!     ALLOWS DC AND DS TO BE RECOVERED BY THE FOLLOWING ALGORITHM:
!            IF Z=1  SET  DC=0.D0  AND  DS=1.D0
!            IF DABS(Z) < 1  SET  DC=SQRT(1-Z**2)  AND  DS=Z
!            IF DABS(Z) > 1  SET  DC=1/Z  AND  DS=SQRT(1-DC**2)

!     NORMALLY, THE SUBPROGRAM DROT(N,DX,INCX,DY,INCY,DC,DS) WILL
!     NEXT BE CALLED TO APPLY THE TRANSFORMATION TO A 2 BY N MATRIX.

! ------------------------------------------------------------------
REAL (dp), INTENT(IN OUT)  :: da
REAL (dp), INTENT(IN OUT)  :: db
REAL (dp), INTENT(OUT)     :: dc
REAL (dp), INTENT(OUT)     :: ds

REAL (dp)  :: u, v, r

IF (ABS(da) > ABS(db)) THEN
  ! *** HERE ABS(DA) > ABS(DB) ***
  u = da + da
  v = db / u

!     NOTE THAT U AND R HAVE THE SIGN OF DA
  r = SQRT(.25D0 + v**2) * u

!     NOTE THAT DC IS POSITIVE
  dc = da / r
  ds = v * (dc + dc)
  db = ds
  da = r
ELSE IF (db /= 0.d0) THEN
  ! *** HERE ABS(DA) <= ABS(DB) AND DB /= 0.D0 ***
  u = db + db
  v = da / u

!     NOTE THAT U AND R HAVE THE SIGN OF DB
!     (R IS IMMEDIATELY STORED IN DA)
  da = SQRT(.25D0 + v**2) * u

!     NOTE THAT DS IS POSITIVE
  ds = db / da
  dc = v * (ds + ds)
  IF (dc == 0.d0) THEN
    db = 1.d0
  ELSE
    db = 1.d0 / dc
  END IF
ELSE
  ! *** HERE DA = DB = 0.D0 ***
  dc = 1.d0
  ds = 0.d0
END IF
RETURN

END SUBROUTINE drotg


SUBROUTINE dswap1 (n, dx, dy)
  INTEGER, INTENT(IN)      :: n
  REAL (dp), INTENT(IN OUT) :: dx(0:*)
  REAL (dp), INTENT(IN OUT) :: dy(0:*)

  REAL (dp)  :: dtemp
  INTEGER    :: i        
  INTEGER    :: m

  IF(n <= 0) RETURN

  !         CODE FOR BOTH INCREMENTS EQUAL TO 1
  !         CLEAN-UP LOOP

  m = MOD(n,3)
  IF (m /= 0) THEN
    DO i = 0, m-1
      dtemp = dx(i)
      dx(i) = dy(i)
      dy(i) = dtemp
    END DO
    IF( n < 3 ) RETURN 
  END IF

  ! 2Ԗڂ̃[v̊JnCfbNX0x[X m ƂȂ
  ! [v0x[X (m  n-1 ܂ŁAXebv3)
  DO i = m, n-1, 3
    dtemp = dx(i)
    dx(i) = dy(i)
    dy(i) = dtemp
    dtemp = dx(i + 1)
    dx(i + 1) = dy(i + 1)
    dy(i + 1) = dtemp
    dtemp = dx(i + 2)
    dx(i + 2) = dy(i + 2)
    dy(i + 2) = dtemp
  END DO
  RETURN
END SUBROUTINE dswap1


SUBROUTINE drot1 (n, dx, dy, c, s)
  INTEGER, INTENT(IN)      :: n
  REAL (dp), INTENT(IN OUT)  :: dx(0:*) ! 0x[Xz
  REAL (dp), INTENT(IN OUT)  :: dy(0:*) ! 0x[Xz
  REAL (dp), INTENT(IN)      :: c
  REAL (dp), INTENT(IN)      :: s

  REAL (dp)  :: dtemp
  INTEGER    :: i       ! [vϐiɃl[ (i)

  IF(n <= 0) RETURN

  ! [v0x[X (0  n-1 ܂)
  DO i = 0, n-1
    dtemp = c*dx(i) + s*dy(i)
    dy(i) = c*dy(i) - s*dx(i)
    dx(i) = dtemp
  END DO
  ! RETURN ̓Tu[`̍ŌɋLqĂΏȗ\ł
END SUBROUTINE drot1


SUBROUTINE dsvdc(x, n, p, s, e, u, v, job, info)

INTEGER, INTENT(IN)        :: n
INTEGER, INTENT(IN)        :: p
REAL (dp), INTENT(IN OUT)  :: x(0:,0:)
REAL (dp), INTENT(OUT)  :: s(0:)
REAL (dp), INTENT(OUT) :: e(0:)
REAL (dp), INTENT(OUT)   :: u(0:,0:)
REAL (dp), INTENT(OUT)     :: v(0:,0:)
INTEGER, INTENT(IN)        :: job
INTEGER, INTENT(OUT)       :: info



!     DSVDC IS A SUBROUTINE TO REDUCE A DOUBLE PRECISION NXP MATRIX X
!     BY ORTHOGONAL TRANSFORMATIONS U AND V TO DIAGONAL FORM.  THE
!     DIAGONAL ELEMENTS S(I) ARE THE SINGULAR VALUES OF X.  THE
!     COLUMNS OF U ARE THE CORRESPONDING LEFT SINGULAR VECTORS,
!     AND THE COLUMNS OF V THE RIGHT SINGULAR VECTORS.

!     ON ENTRY

!         X         DOUBLE PRECISION(LDX,P), WHERE LDX.GE.N.
!                   X CONTAINS THE MATRIX WHOSE SINGULAR VALUE
!                   DECOMPOSITION IS TO BE COMPUTED.  X IS
!                   DESTROYED BY DSVDC.

!         LDX       INTEGER.
!                   LDX IS THE LEADING DIMENSION OF THE ARRAY X.

!         N         INTEGER.
!                   N IS THE NUMBER OF ROWS OF THE MATRIX X.

!         P         INTEGER.
!                   P IS THE NUMBER OF COLUMNS OF THE MATRIX X.

!         LDU       INTEGER.
!                   LDU IS THE LEADING DIMENSION OF THE ARRAY U.
!                   (SEE BELOW).

!         LDV       INTEGER.
!                   LDV IS THE LEADING DIMENSION OF THE ARRAY V.
!                   (SEE BELOW).

!         JOB       INTEGER.
!                   JOB CONTROLS THE COMPUTATION OF THE SINGULAR
!                   VECTORS.  IT HAS THE DECIMAL EXPANSION AB
!                   WITH THE FOLLOWING MEANING

!                        A.EQ.0    DO NOT COMPUTE THE LEFT SINGULAR VECTORS.
!                        A.EQ.1    RETURN THE N LEFT SINGULAR VECTORS IN U.
!                        A.GE.2    RETURN THE FIRST MIN(N,P) SINGULAR
!                                  VECTORS IN U.
!                        B.EQ.0    DO NOT COMPUTE THE RIGHT SINGULAR VECTORS.
!                        B.EQ.1    RETURN THE RIGHT SINGULAR VECTORS IN V.

!     ON RETURN

!         S         DOUBLE PRECISION(MM), WHERE MM=MIN(N+1,P).
!                   THE FIRST MIN(N,P) ENTRIES OF S CONTAIN THE SINGULAR
!                   VALUES OF X ARRANGED IN DESCENDING ORDER OF MAGNITUDE.

!         E         DOUBLE PRECISION(P).
!                   E ORDINARILY CONTAINS ZEROS.  HOWEVER SEE THE
!                   DISCUSSION OF INFO FOR EXCEPTIONS.

!         U         DOUBLE PRECISION(LDU,K), WHERE LDU.GE.N.  IF
!                                   JOBA.EQ.1 THEN K.EQ.N, IF JOBA.GE.2
!                                   THEN K.EQ.MIN(N,P).
!                   U CONTAINS THE MATRIX OF LEFT SINGULAR VECTORS.
!                   U IS NOT REFERENCED IF JOBA.EQ.0.  IF N.LE.P
!                   OR IF JOBA.EQ.2, THEN U MAY BE IDENTIFIED WITH X
!                   IN THE SUBROUTINE CALL.

!         V         DOUBLE PRECISION(LDV,P), WHERE LDV.GE.P.
!                   V CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.
!                   V IS NOT REFERENCED IF JOB.EQ.0.  IF P.LE.N,
!                   THEN V MAY BE IDENTIFIED WITH X IN THE
!                   SUBROUTINE CALL.

!         INFO      INTEGER.
!                   THE SINGULAR VALUES (AND THEIR CORRESPONDING SINGULAR
!                   VECTORS) S(INFO+1),S(INFO+2),...,S(M) ARE CORRECT
!                   (HERE M=MIN(N,P)).  THUS IF INFO.EQ.0, ALL THE
!                   SINGULAR VALUES AND THEIR VECTORS ARE CORRECT.
!                   IN ANY EVENT, THE MATRIX B = TRANS(U)*X*V IS THE
!                   BIDIAGONAL MATRIX WITH THE ELEMENTS OF S ON ITS DIAGONAL
!                   AND THE ELEMENTS OF E ON ITS SUPER-DIAGONAL (TRANS(U)
!                   IS THE TRANSPOSE OF U).  THUS THE SINGULAR VALUES
!                   OF X AND B ARE THE SAME.

!     LINPACK. THIS VERSION DATED 03/19/79 .
!     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.

!     DSVDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.

!     EXTERNAL DROT
!     BLAS DAXPY,DDOT,DSCAL,DSWAP,DNRM2,DROTG
!     FORTRAN DABS,DMAX1,MAX0,MIN0,MOD,DSQRT

!     INTERNAL VARIABLES

INTEGER :: iter, j, jobu, k, kase, kk, l, ll, lm1, lp1, ls, lu, m, maxit,  &
    mm, mm1, nct, nctp1, ncu, nrt, nrtp1
REAL (dp) :: t, work(0:n-1)
REAL (dp) :: b, c, cs, el, emm1, f, g, scale, shift, sl, sm, sn,  &
    smm1, t1, test, ztest
LOGICAL :: wantu, wantv


!     SET THE MAXIMUM NUMBER OF ITERATIONS.

maxit = 30

!     DETERMINE WHAT IS TO BE COMPUTED.

wantu = .false.
wantv = .false.
jobu = MOD(job,100)/10
ncu = n
IF (jobu > 1) ncu = MIN(n,p)
IF (jobu /= 0) wantu = .true.
IF (MOD(job,10) /= 0) wantv = .true.

!     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS
!     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.

info = 0
  nct = MIN(n-1, p)
  s(0:nct) = 0.0_dp

  nrt = MAX(0, MIN(p-2,n))
  lu = MAX(nct,nrt)
  IF (lu >= 1) THEN
    DO  l = 1, lu
      lp1 = l + 1
      IF (l <= nct) THEN

        s(l-1) = SQRT( SUM( x(l-1:n-1,l-1)**2 ) )


        IF (s(l-1) /= 0.0D0) THEN
        IF (x(l-1,l-1) /= 0.0D0) s(l-1) = SIGN(s(l-1), x(l-1,l-1))
        x(l-1:n-1,l-1) = x(l-1:n-1,l-1) / s(l-1)
        x(l-1,l-1) = 1.0D0 + x(l-1,l-1)

        END IF
        s(l-1) = -s(l-1)
      END IF

      IF (p >= lp1) THEN
        DO  j = lp1, p
          IF (l <= nct .AND. s(l-1) /= 0.0D0) THEN
        
!             APPLY THE TRANSFORMATION.
        
        t = -DOT_PRODUCT(x(l-1:n-1,l-1), x(l-1:n-1,j-1)) / x(l-1,l-1)
        x(l-1:n-1,j-1) = x(l-1:n-1,j-1) + t * x(l-1:n-1,l-1)

      END IF
      
!           PLACE THE L-TH ROW OF X INTO  E FOR THE
!           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.
      
      e(j-1) = x(l-1,j-1)
    END DO
  END IF


   IF (wantu .AND. l <= nct) THEN
    
!           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK MULTIPLICATION.
    
    u(l-1 : n-1, l-1) = x(l-1:n-1,l-1)

  END IF

   IF (l > nrt) CYCLE
  
!       COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE
!       L-TH SUPER-DIAGONAL IN e(l-1).

  e(l-1) = SQRT( SUM( e(lp1-1:p-1)**2 ) )
  IF (e(l-1) /= 0.0D0) THEN ! GOTO 80 ̏FIF𔽓]AubN
    IF (e(lp1-1) /= 0.0D0) e(l-1) = SIGN(e(l-1), e(lp1-1))
    e(lp1-1:lp1+p-l-2) = e(lp1-1:p-1) / e(l-1)
    e(lp1-1) = 1.0D0 + e(lp1-1)
  END IF

  ! x 80 ͏܂Bȉ̏ e(l-1) ̌̒l([ǂ)Ɋւ炸s܂B
  e(l-1) = -e(l-1)
  IF (lp1 <= n .AND. e(l-1) /= 0.0D0) THEN

!       APPLY THE TRANSFORMATION.

    work(lp1-1 : n-1) = 0.0D0  
    DO  j = lp1, p
      work(lp1-1 : lp1+n-l-2) = work(lp1-1 : lp1+n-l-2) + e(j-1) * x(lp1-1 : lp1+n-l-2, j-1)
    END DO
    DO  j = lp1, p
      x(lp1-1 : lp1+n-l-2, j-1) = x(lp1-1 : lp1+n-l-2, j-1) - (e(j-1)/e(lp1-1)) * work(lp1-1 : lp1+n-l-2)
    END DO
  END IF

  IF (.NOT.wantv) CYCLE

!         PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT
!         BACK MULTIPLICATION.

    v(lp1-1 : p-1, l-1) = e(lp1-1:p-1)

END DO

END IF
!     SET UP THE FINAL BIDIAGONAL MATRIX OF ORDER M.

  m = MIN(p,n+1)
nctp1 = nct + 1
nrtp1 = nrt + 1
IF (nct < p) s(nctp1-1) = x(nctp1-1,nctp1-1)
IF (n < m) s(m-1) = 0.0D0
IF (nrtp1 < m) e(nrtp1-1) = x(nrtp1-1,m-1)

e(m-1) = 0.0D0

!     IF REQUIRED, GENERATE U.

IF (wantu) THEN
  IF (ncu >= nctp1) THEN ! GOTO 200 ̏FIF𔽓]AubN
    DO  j = nctp1, ncu
      u(0:n-1,j-1) = 0.0_dp
      u(j-1,j-1) = 1.0_dp
    END DO
  END IF ! IF (ncu >= nctp1) ̏I

  ! x 200 ͏܂
  DO  ll = 1, nct
    l = nct - ll + 1
    IF (s(l-1) /= 0.0D0) THEN
      lp1 = l + 1
      IF (ncu >= lp1) THEN
        DO  j = lp1, ncu
          t = -DOT_PRODUCT(u(l-1:n-1,l-1), u(l-1:n-1,j-1)) / u(l-1,l-1)
          u(l-1:n-1,j-1) = u(l-1:n-1,j-1) + t * u(l-1:n-1,l-1)
        END DO
      END IF

      u(l-1:n-1,l-1) = -u(l-1:n-1,l-1)
      u(l-1,l-1) = 1.0D0 + u(l-1,l-1)
      lm1 = l - 1
      IF (lm1 >= 1) THEN
        u(0:lm1-1,l-1) = 0.0_dp
      END IF
    ELSE
      u(0:n-1,l-1) = 0.0_dp
      u(l-1,l-1) = 1.0_dp
    END IF
  END DO
END IF ! IF (wantu)

!     IF IT IS REQUIRED, GENERATE V.

! x 300 ͏܂
IF (wantv) THEN
  DO  ll = 1, p
    l = p - ll + 1
    lp1 = l + 1
    IF (l <= nrt .AND. e(l-1) /= 0.0D0) THEN
    DO  j = lp1, p
        t = -DOT_PRODUCT(v(lp1-1 : lp1+p-l-1-1, l-1), v(lp1-1 : lp1+p-l-1-1, j-1)) / v(lp1-1, l-1)
        v(lp1-1 : lp1+p-l-1-1, j-1) = v(lp1-1 : lp1+p-l-1-1, j-1) + t * v(lp1-1 : lp1+p-l-1-1, l-1)
      END DO
    END IF
    
    v(0:p-1, l-1) = 0.0D0
    v(l-1, l-1) = 1.0D0
  END DO
END IF

!     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.

mm = m
iter = 0

DO

!        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.

IF (m == 0) THEN
  EXIT
END IF

!        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET FLAG AND RETURN.

IF (iter >= maxit) THEN
  info = m
  EXIT
END IF
!        THIS SECTION OF THE PROGRAM INSPECTS FOR NEGLIGIBLE ELEMENTS
!        IN THE S AND E ARRAYS.  ON COMPLETION
!        THE VARIABLES KASE AND L ARE SET AS FOLLOWS.

! KASE = 1 IF s(M-1) AND e(L-2) ARE NEGLIGIBLE AND L < M
! KASE = 2 IF s(L-1) IS NEGLIGIBLE AND L < M
! KASE = 3 IF e(L-2) IS NEGLIGIBLE, L < M, AND
! s(L-1) THROUGH s(M-1) ARE NOT NEGLIGIBLE (QR STEP).
! KASE = 4 IF e(M-2) IS NEGLIGIBLE (CONVERGENCE).

DO  ll = 1, m
  l = m - ll
  IF (l == 0) EXIT
  test = ABS(s(l-1)) + ABS(s(l)) ! s is already 0-based
  ztest = test + ABS(e(l-1))
  IF (ztest == test) THEN
    e(l-1) = 0.0D0
    EXIT
  END IF
END DO


! (̒ODO[v 'l' ̒lŏ̌ɊÂĐݒ肳Ă܂)
IF (l == m - 1) THEN
  kase = 4
  l = l + 1
ELSE
  ! ls ̒lvZCς݂̃[v
  ls = l ! ls̏lݒ (ł 'l' ͍ŏe(l)̒l)
  DO k = m, l + 1, -1
    test = 0.0D0
    IF (k /= m) test = test + ABS(e(k-1))
    IF (k /= l + 1) test = test + ABS(e(k-1-1))
    ztest = test + ABS(s(k-1))
    IF (ztest == test) THEN
      s(k-1) = 0.0D0
      ls = k
      EXIT
    END IF
  END DO
  ! ls ݒ肳ꂽBł 'l' ͈ˑRƂčŏe(l)̒lێ

  IF (ls == l) THEN
    kase = 3
    l = l + 1
  ELSE IF (ls == m) THEN
    kase = 1
    l = l + 1
  ELSE
    kase = 2
    l = ls + 1 ! kase=2 ̏ꍇ ls  l XV ( l=ls; l=l+1 ɑ)
  END IF
END IF

!       PERFORM THE TASK INDICATED BY KASE.

SELECT CASE ( kase )
  CASE (    1)
    !     DEFLATE NEGLIGIBLE s(m-1).
    mm1 = m - 1
    f = e(m-1-1)
    e(m-1-1) = 0.0D0
    DO  kk = l, mm1
      k = mm1 - kk + l
      t1 = s(k-1)
      CALL drotg(t1, f, cs, sn)
      s(k-1) = t1
      IF (k /= l) THEN
        f = -sn*e(k-1-1)
        e(k-1-1) = cs*e(k-1-1)
      END IF

      IF (wantv) CALL drot1(p, v(0:,k-1), v(0:,m-1), cs, sn)
    END DO
    CYCLE
CASE (    2)
    !     SPLIT AT NEGLIGIBLE s(l-1).
    f = e(l-1-1)
    e(l-1-1) = 0.0D0
    DO  k = l, m
      t1 = s(k-1)
      CALL drotg(t1, f, cs, sn)
      s(k-1) = t1
      f = -sn*e(k-1)
      e(k-1) = cs*e(k-1)
      IF (wantu) CALL drot1(n, u(0:,k-1), u(0:,l-1-1), cs, sn)
    END DO
    CYCLE


  CASE (    3)
    !     PERFORM ONE QR STEP.
    !       CALCULATE THE SHIFT.
    scale = MAX(ABS(s(m-1)), ABS(s(m-2)), ABS(e(m-1-1)), ABS(s(l-1)), ABS(e(l-1)))
    sm = s(m-1)/scale
    smm1 = s(m-2)/scale
    emm1 = e(m-1-1)/scale
    sl = s(l-1)/scale
    el = e(l-1)/scale
    b = ((smm1 + sm)*(smm1 - sm) + emm1**2)/2.0D0
    c = (sm*emm1)**2
    shift = 0.0D0
    IF (b /= 0.0D0 .OR. c /= 0.0D0) THEN
      shift = SQRT(b**2+c)
      IF (b < 0.0D0) shift = -shift
      shift = c/(b + shift)
    END IF

    f = (sl + sm)*(sl - sm) - shift
    g = sl*el

    !       CHASE ZEROS.
    mm1 = m - 1
    DO  k = l, mm1
      CALL drotg(f, g, cs, sn)
      IF (k /= l) e(k-1-1) = f
      f = cs*s(k-1) + sn*e(k-1)
      e(k-1) = cs*e(k-1) - sn*s(k-1)
      g = sn*s(k)
      s(k) = cs*s(k)
      IF (wantv) CALL drot1(p, v(0:,k-1), v(0:,k), cs, sn)
      CALL drotg(f, g, cs, sn)
      s(k-1) = f
      f = cs*e(k-1) + sn*s(k)
      s(k) = -sn*e(k-1) + cs*s(k)
      g = sn*e(k)
      e(k) = cs*e(k)
      IF (wantu .AND. k < n) CALL drot1(n, u(0:,k-1), u(0:,k), cs, sn)
    END DO
    e(m-1-1) = f
    iter = iter + 1
    CYCLE
    
  CASE (    4)

    !     CONVERGENCE.
    !       MAKE THE SINGULAR VALUE  POSITIVE.
    IF (s(l-1) < 0.0D0) THEN
      s(l-1) = -s(l-1)
      IF (wantv) v(0:p-1,l-1) = -v(0:p-1,l-1)
    END IF

    !       ORDER THE SINGULAR VALUE.
    ! x590DO WHILE[v͂Ɋ܂܂܂
    DO
      IF (l == mm) EXIT          ! 1: lmmȂ烋[vEo
      IF (s(l-1) >= s(l)) EXIT    ! 2: l < mm ŁA΃[vEo

      ! LEXITɈvȂꍇ (l < mm AND s(l-1) < s(l) ^)
      t = s(l-1)
      s(l-1) = s(l)
      s(l) = t
      IF (wantv .AND. l < p) CALL dswap1(p, v(0:,l-1), v(0:,l))
      IF (wantu .AND. l < n) CALL dswap1(n, u(0:,l-1), u(0:,l))
      l = l + 1
    END DO

    iter = 0 ! x 600 ̏
    m = m - 1  ! x 600 ̏
    CYCLE
END SELECT

End Do


END SUBROUTINE dsvdc

END MODULE SVD
