PROGRAM BENCHMARK_SVD_FORTRAN_ORIGINAL
    USE SVD
    USE, INTRINSIC :: ISO_FORTRAN_ENV

    IMPLICIT NONE

    ! 変数宣言
    CHARACTER(LEN=1024) :: filepath
    INTEGER             :: i, iargc_val, arg_stat, io_stat, file_unit
    INTEGER             :: n, p, job, info
    INTEGER             :: num_elements
    REAL(8), ALLOCATABLE :: data_1d(:)
    REAL(8), ALLOCATABLE :: x(:,:), s(:), e(:), u(:,:), v(:,:)
    INTEGER             :: start_count, end_count, count_rate
    REAL(8)             :: duration

    ! 1. コマンドライン引数からファイルパスを取得
    iargc_val = IARGC()
    IF (iargc_val /= 1) THEN
        WRITE(*,*) 'Usage: benchmark_svd_fortran_original.exe <data_file_path>'
        STOP 1
    END IF
    CALL GET_COMMAND_ARGUMENT(1, filepath, STATUS=arg_stat)
    IF (arg_stat /= 0) THEN
        WRITE(*,*) 'Error: Could not get command line argument.'
        STOP 1
    END IF

    ! 2. バイナリファイルから行列データを読み込む
    OPEN(NEWUNIT=file_unit, FILE=TRIM(filepath), ACCESS='STREAM', FORM='UNFORMATTED', STATUS='OLD', IOSTAT=io_stat)
    IF (io_stat /= 0) THEN
        WRITE(*,*) 'Error: Could not open file: ', TRIM(filepath)
        STOP 1
    END IF

    INQUIRE(UNIT=file_unit, SIZE=num_elements)
    num_elements = num_elements / 8

    ALLOCATE(data_1d(num_elements))
    READ(file_unit) data_1d
    CLOSE(file_unit)

    ! 次元を計算し、2次元配列に変換
    n = INT(SQRT(REAL(num_elements, 8)))
    p = n
    IF (n * p /= num_elements) THEN
        WRITE(*,*) 'Error: File size does not represent a square matrix.'
        STOP 1
    END IF

    ! 0ベースの配列として割り当て
    ALLOCATE(x(0:n-1, 0:p-1))
    x = RESHAPE(data_1d, [n, p])
    DEALLOCATE(data_1d)

    ! 結果を格納するための配列を準備
    job = 11
    ALLOCATE(s(0:MIN(n,p)-1), e(0:p-1), u(0:n-1, 0:n-1), v(0:p-1, 0:p-1))

    CALL SYSTEM_CLOCK(COUNT_RATE=count_rate)

    ! --- ここからが計測対象 ---
    CALL SYSTEM_CLOCK(start_count)

    ! 3. SVD計算サブルーチンの呼び出し
    CALL dsvdc(x, n, p, s, e, u, v, job, info)

    CALL SYSTEM_CLOCK(end_count)
    ! --- ここまでが計測対象 ---

    duration = REAL(end_count - start_count) / REAL(count_rate)

    ! 計算が成功したかを確認
    IF (info /= 0) THEN
        WRITE(ERROR_UNIT,*) 'Warning: dsvdc returned error code: ', info
    END IF

    ! 4. 結果（秒数）のみを標準出力に出力
    WRITE(*, '(F12.8)') duration

    ! 5. 検証のため、特異値と先頭固有ベクトルを標準エラー出力に出力
    WRITE(ERROR_UNIT, '("Top 5 singular values (Fortran Original):")')
    ! 横一列にスペース区切りで出力
    WRITE(ERROR_UNIT, '(5(F20.15, A))') (s(i), ' ', i=0, 4)

    WRITE(ERROR_UNIT, *) ! 可読性のための空行

    WRITE(ERROR_UNIT, '("First 3 components of leading eigenvector (1st column of U):")')
    ! uの最初の列(i=0)の、最初の3要素(0から2)を横一列に出力
    WRITE(ERROR_UNIT, '(3(F20.15, A))') (u(i, 0), ' ', i=0, 2)

END PROGRAM BENCHMARK_SVD_FORTRAN_ORIGINAL